/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsData;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsTasklet;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceList;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyException;
import com.ibm.hsc.common.util.Trace;

public class IOSurveyResultsUtils {
    private static final String TRACE_MASKD = "JUCODECD";
    private static final String TRACE_MASKF = "JUCODECF";
    private static final String TRACE_MASKT = "JUCODECT";
    static final String NOT_FOUND = SurveyFileResult.notFound;
    IOSurveyResultsTasklet IOTask;
    final String RESULTS_BEAN = "IO Results Bean";

    public IOSurveyResultsUtils() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsUtils()");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsUtils()");
        }
    }

    public String convertMTMStoAsterisk(String string) {
        int n;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->IOSurveyResultsUtils().convertMTMStoAsterisk = " + string);
        }
        if ((n = string.indexOf("_")) == -1) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-IOSurveyResultsUtils().convertMTMStoAsterisk = " + string);
            }
            return string;
        }
        String string2 = string.substring(0, n) + "*" + string.substring(n + 1);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-IOSurveyResultsUtils().convertMTMStoAsterisk = " + string2);
        }
        return string2;
    }

    public ResourceList createResources(SurveyFileResult[] surveyFileResultArray, RepositoryItem repositoryItem, IOSurveyResultsData iOSurveyResultsData) throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsUtils().createResources");
        }
        String string = " ";
        ResourceList resourceList = new ResourceList();
        int n = surveyFileResultArray.length;
        for (int i = 0; i < n; ++i) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Using Survey file inSurveyFile[" + i + "] of " + n);
            }
            if (surveyFileResultArray[i] == null) {
                if (1 > Trace.LEVEL) continue;
                Trace.trace(TRACE_MASKD, "No survey file at inSurveyFile[" + i + "] of " + n);
                continue;
            }
            int n2 = surveyFileResultArray[i].size();
            boolean bl = true;
            ResourceItem resourceItem = null;
            for (int j = 1; j < n2; ++j) {
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                String string11;
                String string12;
                String string13;
                String string14;
                String string15;
                String string16;
                String string17;
                String string18;
                int n3;
                String string19;
                String string20;
                boolean bl2 = false;
                String string21 = surveyFileResultArray[i].findRecordIndex(j);
                String string22 = surveyFileResultArray[i].getValue(string21, "REC");
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "Using record " + j + " of Survey file inSurveyFile[" + i + "] of " + n2);
                }
                if (string22.equals("HDR")) {
                    bl2 = false;
                    string = surveyFileResultArray[i].getValue(string21, "CATDATE");
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Service Level set to: " + string);
                    }
                    repositoryItem.setServiceLevels(string);
                    if (repositoryItem.getReposType() == 0) {
                        // empty if block
                    }
                    if (repositoryItem.getReposType() == 4) {
                        // empty if block
                    }
                    if (repositoryItem.getReposType() == 1) {
                        repositoryItem.setDirPath(surveyFileResultArray[i].getValue(string21, "CDPATH").trim());
                    }
                }
                if (string22.equals("OS")) {
                    bl2 = true;
                    string20 = surveyFileResultArray[i].getValue(string21, "PARID");
                    if (string20 != null && string20.trim().length() == 0) {
                        string20 = "000";
                    }
                    string19 = "Partition " + string20;
                    n3 = 1;
                    string18 = this.convertMTMStoAsterisk(surveyFileResultArray[i].getValue(string21, "MTMS"));
                    if (bl) {
                        resourceList.addMTMS(string18);
                        bl = false;
                    }
                    string17 = surveyFileResultArray[i].getValue(string21, "HOSTNAME");
                    string16 = surveyFileResultArray[i].getValue(string21, "OSLVL");
                    string15 = surveyFileResultArray[i].getValue(string21, "OSLVL");
                    string14 = surveyFileResultArray[i].getValue(string21, "ISMAN");
                    string13 = "";
                    string12 = " ";
                    string11 = surveyFileResultArray[i].getValue(string21, "REBOOT");
                    string10 = "";
                    string9 = "";
                    string8 = "";
                    string7 = "";
                    string6 = "";
                    string5 = surveyFileResultArray[i].getValue(string21, "CONC");
                    string4 = "";
                    string3 = "";
                    string2 = "";
                    resourceItem = new ResourceItem(string19, n3, string18, string17, string16, string15, string12, string11, string10, string20, string9, string8, string14, string13, string7, string6, string5, string4, string3, string2);
                }
                if (string22.equals("DEV")) {
                    bl2 = true;
                    string19 = surveyFileResultArray[i].getValue(string21, "DEVTYPE");
                    n3 = 2;
                    string18 = this.convertMTMStoAsterisk(surveyFileResultArray[i].getValue(string21, "MTMS"));
                    if (bl) {
                        resourceList.addMTMS(string18);
                        bl = false;
                    }
                    string17 = surveyFileResultArray[i].getValue(string21, "DESC");
                    string16 = this.determineCurrentLevel(surveyFileResultArray[i], string21, string22);
                    string15 = this.determineAvailableLevel(surveyFileResultArray[i], string21, string22);
                    string12 = "";
                    string14 = surveyFileResultArray[i].getValue(string21, "ISMAN");
                    string13 = surveyFileResultArray[i].getValue(string21, "VFORM");
                    string11 = surveyFileResultArray[i].getValue(string21, "REBOOT");
                    string10 = surveyFileResultArray[i].getValue(string21, "RPMFILE");
                    if (surveyFileResultArray[i].getValue(string21, "PARID").equals(NOT_FOUND)) {
                        string20 = "000";
                    } else {
                        string20 = surveyFileResultArray[i].getValue(string21, "PARID");
                        if (string20 != null && string20.trim().length() == 0) {
                            string20 = "000";
                        }
                    }
                    string9 = surveyFileResultArray[i].getValue(string21, "DEVNM");
                    string8 = surveyFileResultArray[i].getValue(string21, "SRVPAR");
                    string7 = surveyFileResultArray[i].getValue(string21, "IMGFILE");
                    string6 = surveyFileResultArray[i].getValue(string21, "IMGFILE-1");
                    string5 = surveyFileResultArray[i].getValue(string21, "CONC");
                    string4 = surveyFileResultArray[i].getValue(string21, "CDDIR");
                    string3 = surveyFileResultArray[i].getValue(string21, "WEBDIR");
                    string2 = surveyFileResultArray[i].getValue(string21, "FTPDIR");
                    resourceItem = new ResourceItem(string19, n3, string18, string17, string16, string15, string12, string11, string10, string20, string9, string8, string14, string13, string7, string6, string5, string4, string3, string2);
                }
                if (!bl2) continue;
                resourceList.addResource(resourceItem);
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "Assigned resources to ResourceList");
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsUtils().createResources");
        }
        return resourceList;
    }

    protected String determineCurrentLevel(SurveyFileResult surveyFileResult, String string, String string2) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "-> determineCurrentLevel()");
        }
        String string3 = "";
        if (string2.equals("SYS")) {
            if (surveyFileResult.getValue(string, "SYSLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "SRVINLVL");
            }
            return surveyFileResult.getValue(string, "SYSINLVL");
        }
        if (string2.equals("DEV")) {
            string3 = surveyFileResult.getValue(string, "LSMLTLVL").equals(NOT_FOUND) ? surveyFileResult.getValue(string, "LDBINLVL") : surveyFileResult.getValue(string, "LSMINLVL");
            if (string3.equals(NOT_FOUND)) {
                return string3;
            }
            return this.determineLevel(surveyFileResult, string, string2, string3);
        }
        if (string2.equals("BPA")) {
            if (surveyFileResult.getValue(string, "LSMLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "LDBINLVL");
            }
            return surveyFileResult.getValue(string, "LSMINLVL");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "ERROR, Record Type was not SYS, BPA or DEV ");
            Trace.trace(TRACE_MASKT, "<- determineCurrentLevel() ");
        }
        return NOT_FOUND;
    }

    protected String determineAvailableLevel(SurveyFileResult surveyFileResult, String string, String string2) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "-> determineAvailableLevel()");
        }
        String string3 = " ";
        if (string2.equals("SYS")) {
            if (surveyFileResult.getValue(string, "SYSLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "SRVLTLVL");
            }
            return surveyFileResult.getValue(string, "SYSLTLVL");
        }
        if (string2.equals("DEV")) {
            if (surveyFileResult.getValue(string, "LSMLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "LDBLTLVL");
            }
            return surveyFileResult.getValue(string, "LSMLTLVL");
        }
        if (string2.equals("BPA")) {
            if (surveyFileResult.getValue(string, "LSMLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "LDBLTLVL");
            }
            return surveyFileResult.getValue(string, "LSMLTLVL");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "ERROR, Record Type was not SYS, BPA or DEV ");
            Trace.trace(TRACE_MASKT, "<-determineAvailableLevel() ");
        }
        return NOT_FOUND;
    }

    protected String determinePreviousLevel(SurveyFileResult surveyFileResult, String string, String string2) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "-> determinePreviousLevel()");
        }
        if (string2.equals("SYS")) {
            if (surveyFileResult.getValue(string, "SYSLTLVL-1").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "SRVLTLVL-1");
            }
            return surveyFileResult.getValue(string, "SYSLTLVL-1");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "<- determinePreviousLevel()");
        }
        return NOT_FOUND;
    }

    protected String determineLevel(SurveyFileResult surveyFileResult, String string, String string2, String string3) {
        String string4 = surveyFileResult.getValue(string, "LSMFORM");
        int n = 0;
        String string5 = "";
        if (string2.equals("DEV")) {
            int n2;
            if (string4.equals(NOT_FOUND)) {
                n = 0;
            } else {
                n = Integer.parseInt(string4.substring(0, 1));
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "Number of tokens is: " + n);
                }
                if (n > 0) {
                    string5 = string4.substring(1).trim();
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKD, "Token Value is: " + string5);
                    }
                }
            }
            if (n == 0) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "returning: " + string3);
                }
                return string3;
            }
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                if ((n3 = string3.indexOf(string5, n3 + 1)) != -1) continue;
                return NOT_FOUND;
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Beginning of value at position: " + n3);
            }
            if ((n2 = string3.indexOf("|", n3 + 1)) == -1 && (n2 = string3.indexOf(string5, n3 + 1)) == -1) {
                n2 = string3.length();
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "End of value at position: " + n2);
            }
            String string6 = string3.substring(n3 += string5.length(), n2);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "returning: " + string6);
            }
            return string6;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- determinePreviousLevel() ");
        }
        return NOT_FOUND;
    }
}

